<?php
require_once '../includes/config.php';
require_once '../includes/DataBaseObjects.php';

header('Content-Type: application/json');
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

try {
    $db = new DataBaseObjects();

    if ($_SERVER['REQUEST_METHOD'] === 'GET') {
        $rates = $db->select('currency_rates', [], '*');
        echo json_encode(['success' => true, 'rates' => $rates]);
        exit;
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $data = json_decode(file_get_contents('php://input'), true);
        if (!is_array($data)) { throw new Exception('Invalid payload'); }

        foreach ($data as $row) {
            if (!isset($row['currency_code']) || !isset($row['units_per_usd'])) { continue; }
            $code = strtoupper(trim($row['currency_code']));
            $units = (float)$row['units_per_usd'];
            if ($code === '' || $units <= 0) { continue; }

            $existing = $db->select('currency_rates', ['currency_code' => $code], '*');
            if (!empty($existing)) {
                $db->update('currency_rates', ['units_per_usd' => $units], ['currency_code' => $code]);
            } else {
                $db->insert('currency_rates', ['currency_code' => $code, 'units_per_usd' => $units]);
            }
        }

        echo json_encode(['success' => true]);
        exit;
    }

    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['error' => $e->getMessage()]);
}
?>


