<?php
// Include necessary files and functions
include_once("../includes/config.php");
include_once("functions.php");

// Set variables
$Page = "edit_Client";
//$Form_Process = "your_form_process.php"; // Ensure this is set properly
//$ID = 1; // Make sure to set this dynamically if needed

// Get necessary data
$result = get_available_clients_variables();
$apps_result = get_avaiable_clients_apps_variables();
$USERS = clients_variables();

// Display success or error messages
Message("edited_successfully", "success", "success_icon.png", "Client Successfully Edited");
Message("Failed_User_Exist", "failed", "error_icon.png", "Error! User Name Already Exists.");
?>
<div class="container mt-5">
    <h3><u>Edit Client</u></h3>
    <form action="<?php echo $Form_Process .$Page. '&id=' . $ID; ?>" method="post">
        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="safa_ea_id" class="form-label">Virgo ID:</label>
                <input type="text" class="form-control" name="safa_ea_id" id="safa_ea_id" value="<?php echo $result['safa_ea_id']; ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="Company_name" class="form-label">Company Name:</label>
                <input type="text" class="form-control" name="Company_name" id="Company_name" value="<?php echo $result['CompanyName']; ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="Person_Incharge" class="form-label">Person Incharge:</label>
                <input type="text" class="form-control" name="Person_Incharge" id="Person_Incharge" value="<?php echo $result['PersonIncharge']; ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="Country" class="form-label">Country:</label>
                <select name="Country" id="Country" class="form-select">
                    <?php Edit_Countries(); ?>
                </select>
            </div>
            <div class="col-md-4 mb-3">
                <label for="City" class="form-label">City:</label>
                <input type="text" class="form-control" name="City" value="<?php echo $result['City']; ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="Telephone" class="form-label">Telephone:</label>
                <input type="text" class="form-control" name="Telephone" value="<?php echo $result['Telephone']; ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="Email" class="form-label">Email:</label>
                <input type="text" class="form-control" name="Email" value="<?php echo $result['Email']; ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="MSN" class="form-label">MSN:</label>
                <input type="text" class="form-control" name="MSN" value="<?php echo $result['MSN']; ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="Purchase_Date" class="form-label">Purchase Date:</label>
                <input type="date" class="form-control" name="Purchase_Date" value="<?php echo date('Y-m-d', strtotime($result['Purchase_Date'])); ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="Renew_Date" class="form-label">Renew Date:</label>
                <input type="date" class="form-control" name="Renew_Date" value="<?php echo date('Y-m-d', strtotime($result['Renew_Date'])); ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="Start_Balance" class="form-label">Start Balance:</label>
                <input type="text" class="form-control" name="Start_Balance" maxlength="8" value="<?php echo $result['Start_Balance']; ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="max_license" class="form-label">Max License:</label>
                <input type="text" class="form-control" name="max_license" maxlength="3" value="<?php echo $result['max_license']; ?>">
            </div>
        </div>
        <div class="row">
            <div class="col-md-4 mb-3 form-check">
                <input type="checkbox" class="form-check-input" name="free_license" id="free_license" value="1" <?php if($result['free_license'] == 1) echo "checked='checked'"; ?>>
                <label for="free_license" class="form-check-label">Free License:</label>
            </div>
            <div class="col-md-4 mb-3 form-check">
                <input class="form-check-input" type="checkbox" name="barcode" value="1" <?php if($result['Barcode_Enabled'] == 1) echo "checked='checked'"; ?>>
                <label class="form-check-label" for="barcode">Barcode</label>
            </div>
        </div>
        <div class="mb-3">
            <label for="Message" class="form-label">Message:</label>
            <textarea name="Message" class="form-control" cols="25" rows="2"><?php echo $result['Message']; ?></textarea>
        </div>
        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="License Code" class="form-label">License Code:  
                    <?php 
                    if($result['license'] == '') { 
                        echo '<a href="https://auth.virgo-sy.com/v6/getlicense.php?id=' . $ID . '" target="_blank" class="btn btn-primary">Get License</a>';
                    } else {
                        echo $result['license'];
                    } 
                    ?>
                </label>
            </div>  
        </div>
        <div class="container-fluid">
            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Available</th>
                            <th>Blocked</th>
                            <th>Application</th>
                            <th>Version</th>
                            <th>User</th>
                            <th>Serial</th>
                            <th>Last Counter</th>
                            <th>Package Limit</th>
                            <th>Last Access</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if ($apps_result) {
                            foreach ($apps_result['App_Id'] as $index => $app_id) {
                                $app = $apps_result['Application_Name'][$index];

                                echo "<tr>";
                                echo '<td class="text-center align-middle">
                                    <input class="form-check-input" name="Available_' . $app . '" type="checkbox" id="Available_' . $app . '" value="1"';
                                if ($apps_result['availability'][$index] == 1) echo "checked='checked'";
                                echo ' /></td>';
                                
                                echo '<td class="text-center align-middle">
                                    <input class="form-check-input" name="Block_' . $app . '" type="checkbox" id="Block_' . $app . '" value="1"';
                                if ($apps_result['Blocked'][$index] == 1) echo "checked='checked'";
                                echo ' /></td>';
                                
                                echo '<td class="text-center align-middle">' . $app . '</td>';
                                echo '<td class="text-center align-middle">' . $apps_result['Version'][$index] . '</td>';
                                echo '<td class="text-center align-middle">' . $apps_result['User'][$index] . '</td>';
                                echo '<td class="text-center align-middle">' . $apps_result['serial'][$index] . '</td>';
                                echo '<td class="text-center align-middle">' . $apps_result['Last_Counter'][$index] . '</td>';
                                
                                echo '<td class="text-start align-middle">
                                    <input class="form-control form-control-sm" style="width: auto; display: inline-block;" name="' . $app . '_Limit" type="text" id="' . $app . '_Limit" value="' . $apps_result['Stop_At'][$index] . '" size="2" maxlength="6" />
                                    <input class="btn btn-primary btn-sm" type="submit" name="submit" value="Edit">
                                </td>';
                                
                                echo '<td class="text-center align-middle">' . $apps_result['Time_stamp'][$index] . '</td>';
                                echo "</tr>";
                            }
                        }
                        ?>
                    </tbody>
                </table>
                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </div>
    </form>
</div>
<div class="row">
    <?php
    get_list_mac();
    Get_Credit();
    ?>
</div>
</body>
</html>
