<?php
include_once("includes/config.php");
include_once("includes/DataBaseObjects.php");

$dbo = new DataBaseObjects();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    if ($name !== '') {
        try {
            $dbo->insert('tbl_account_managers', [
                'name' => $name,
                'email' => ($email !== '' ? $email : null),
                'phone' => ($phone !== '' ? $phone : null),
            ]);
            header("Location: ".SITE_URL."?page=account_managers&status=added_successfully");
            exit;
        } catch (Exception $e) {
            $error = $e->getMessage();
        }
    } else {
        $error = 'Name is required';
    }
}

$managers = $dbo->selectAll('tbl_account_managers', 'id, name, email, phone, created_at');
?>
<div class="container-fluid px-4">
    <h1 class="mt-4">Account Managers</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
        <li class="breadcrumb-item active">Account Managers</li>
    </ol>

    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-user-tie me-1"></i>
            Add Account Manager
        </div>
        <div class="card-body">
            <?php if (!empty($_GET['status']) && $_GET['status']==='added_successfully'): ?>
                <div class="alert alert-success">Added successfully</div>
            <?php endif; ?>
            <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            <form method="post">
                <div class="row mb-3">
                    <div class="col-md-4">
                        <div class="form-floating mb-3">
                            <input type="text" name="name" class="form-control" id="am_name" placeholder="Name" required>
                            <label for="am_name">Name</label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-floating mb-3">
                            <input type="email" name="email" class="form-control" id="am_email" placeholder="Email">
                            <label for="am_email">Email</label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-floating mb-3">
                            <input type="text" name="phone" class="form-control" id="am_phone" placeholder="Phone">
                            <label for="am_phone">Phone</label>
                        </div>
                    </div>
                </div>
                <button class="btn btn-primary" type="submit">Add</button>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <i class="fas fa-list me-1"></i>
            Managers List
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($managers as $m): ?>
                            <tr>
                                <td><?php echo (int)$m['id']; ?></td>
                                <td><?php echo htmlspecialchars($m['name']); ?></td>
                                <td><?php echo htmlspecialchars($m['email']); ?></td>
                                <td><?php echo htmlspecialchars($m['phone']); ?></td>
                                <td><?php echo htmlspecialchars($m['created_at']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>


