<?php
// Include necessary files and functions
include_once("includes/config.php");
include_once("functions.php");

// Set variables
$Page = "edit_client";
//$Form_Process = "your_form_process.php"; // Ensure this is set properly
//$ID = 1; // Make sure to set this dynamically if needed

// Get necessary data (avoid heavy credit fetch on initial load; it's lazy-loaded via JS)
$result = get_available_clients_variables();
$apps_result = get_avaiable_clients_apps_variables();
$USERS = clients_variables();

// Display success or error messages
Message("edited_successfully", "success", "success_icon.png", "Client Successfully Edited");
Message("Failed_User_Exist", "failed", "error_icon.png", "Error! User Name Already Exists.");
?>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Client</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="index.php">Clients</a></li>
                        <li class="breadcrumb-item active">Edit Client</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <?php
            // Display messages
            Message("edited_successfully", "success", "success_icon.png", "Client Successfully Edited");
            Message("Failed_User_Exist", "danger", "error_icon.png", "Error! User Name Already Exists.");
            ?>

            <div class="card">
                <div class="card-body">
                    <form action="<?php echo SITE_URL . '/form_process.php?page=edit_client&id=' . $ID; ?>" method="post">
                        <div class="row">
                            <!-- Basic Information -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="safa_ea_id" class="form-label">Virgo ID</label>
                                    <input type="text" class="form-control" name="safa_ea_id" id="safa_ea_id" 
                                           value="<?php echo $result['safa_ea_id']; ?>">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="Company_name" class="form-label">Company Name</label>
                                    <input type="text" class="form-control" name="Company_name" id="Company_name" 
                                           value="<?php echo $result['CompanyName']; ?>">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="Person_Incharge" class="form-label">Person Incharge</label>
                                    <input type="text" class="form-control" name="Person_Incharge" id="Person_Incharge" 
                                           value="<?php echo $result['PersonIncharge']; ?>">
                                </div>
                            </div>

                            <!-- Contact Information -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="Country" class="form-label">Country</label>
                                    <select name="Country" id="Country" class="form-select">
                                        <?php Edit_Countries(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="City" class="form-label">City</label>
                                    <input type="text" class="form-control" name="City" value="<?php echo $result['City']; ?>">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="Telephone" class="form-label">Telephone</label>
                                    <input type="text" class="form-control" name="Telephone" value="<?php echo $result['Telephone']; ?>">
                                </div>
                            </div>

                            <!-- Additional Information -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="Email" class="form-label">Email</label>
                                    <input type="email" class="form-control" name="Email" value="<?php echo $result['Email']; ?>">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="license_email" class="form-label">License Email</label>
                                    <input type="email" class="form-control" name="license_email" value="<?php echo $result['license_email']; ?>">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="account_manager_id" class="form-label">Account Manager</label>
                                    <select name="account_manager_id" id="account_manager_id" class="form-select">
                                        <option value="">--- Select Account Manager ---</option>
                                        <?php
                                        try {
                                            $dbo = new DataBaseObjects();
                                            $managers = $dbo->selectAll('tbl_account_managers', 'id, name');
                                            $selected = isset($result['account_manager_id']) ? (int)$result['account_manager_id'] : null;
                                            foreach ($managers as $m) {
                                                $isSel = ($selected !== null && (int)$m['id'] === $selected) ? ' selected="selected"' : '';
                                                echo "<option value='".htmlspecialchars($m['id'])."'{$isSel}>".htmlspecialchars($m['name'])."</option>";
                                            }
                                        } catch (Exception $e) {
                                            
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="Connection" class="form-label">Connection</label>
                                    <input type="text" class="form-control" name="Connection" id="Connection" 
                                           value="<?php echo $result['connection_id']; ?>">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="MSN" class="form-label">MSN</label>
                                    <input type="text" class="form-control" name="MSN" value="<?php echo $result['MSN']; ?>">
                                </div>
                            </div>

                            <!-- Dates and Balance -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="Purchase_Date" class="form-label">Purchase Date</label>
                                    <input type="date" class="form-control" name="Purchase_Date" 
                                           value="<?php echo date('Y-m-d', strtotime($result['Purchase_Date'])); ?>">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="Renew_Date" class="form-label">Expiry Date</label>
                                    <input type="date" class="form-control" name="Renew_Date" 
                                           value="<?php echo date('Y-m-d', strtotime($result['Renew_Date'])); ?>">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="Start_Balance" class="form-label">Start Balance</label>
                                    <input type="text" class="form-control" name="Start_Balance" maxlength="8" 
                                           value="<?php echo $result['Start_Balance']; ?>">
                                </div>
                            </div>

                            <!-- License Information -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="max_license" class="form-label">Max License</label>
                                    <input type="text" class="form-control" name="max_license" maxlength="3" 
                                           value="<?php echo $result['max_license']; ?>">
                                </div>
                            </div>
                        </div>

                        <!-- Checkboxes -->
                        <div class="row mt-4">
                            <div class="col-md-3">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" name="free_license" id="free_license" value="1" 
                                           <?php if($result['free_license'] == 1) echo "checked='checked'"; ?>>
                                    <label for="free_license" class="form-check-label">Free License</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="barcode" value="1" 
                                           <?php if($result['Barcode_Enabled'] == 1) echo "checked='checked'"; ?>>
                                    <label class="form-check-label" for="barcode">Barcode</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="alert_enabled" id="alert_enabled" value="1" 
                                           <?php if($result['alert_enabled'] == 1) echo "checked='checked'"; ?>>
                                    <label class="form-check-label" for="alert_enabled">Credit Alert</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="license_enabled" id="license_enabled" value="1" 
                                           <?php if($result['license_enabled'] == 1) echo "checked='checked'"; ?>>
                                    <label class="form-check-label" for="license_enabled">License Enabled</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="enjaz_feeding_center" id="enjaz_feeding_center" value="1" 
                                           <?php if($result['enjaz_feeding_center'] == 1) echo "checked='checked'"; ?>>
                                    <label class="form-check-label" for="enjaz_feeding_center">Enjaz Feeding Center</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="umrah_feeding_center" id="umrah_feeding_center" value="1" 
                                           <?php if($result['umrah_feeding_center'] == 1) echo "checked='checked'"; ?>>
                                    <label class="form-check-label" for="umrah_feeding_center">Umrah Feeding Center</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="enjaz_payment" id="enjaz_payment" value="1" 
                                           <?php if($result['enjaz_payment'] == 1) echo "checked='checked'"; ?>>
                                    <label class="form-check-label" for="enjaz_payment">Enjaz Payment</label>
                                </div>
                            </div>
                        </div>

                        <!-- Message -->
                        <div class="form-group mt-4">
                            <label for="Message" class="form-label">Message</label>
                            <textarea name="Message" class="form-control" rows="3"><?php echo $result['Message']; ?></textarea>
                        </div>

                        <!-- License Code -->
                        <div class="form-group mt-4">
                            <label class="form-label">License Code</label>
                            <div class="license-code">
                                <?php 
                                if($result['license'] == '') { 
                                    echo '<a href="https://auth.virgo-sy.com/v6/getlicense.php?id=' . $ID . '" 
                                          target="_blank" class="btn btn-primary">Get License</a>';
                                } else {
                                    echo '<span class="license-text">' . $result['license'] . '</span>';
                                } 
                                ?>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="form-actions mt-4">
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Applications Table -->
            <div class="card mt-4">
                <div class="card-header">
                    <h3 class="card-title">Applications</h3>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th class="border-bottom text-center" style="width: 80px;">
                                        <i class="bi bi-check-circle" title="Available"></i>
                                    </th>
                                    <th class="border-bottom text-center" style="width: 80px;">
                                        <i class="bi bi-slash-circle" title="Blocked"></i>
                                    </th>
                                    <th class="border-bottom">Application</th>
                                    <th class="border-bottom">Version</th>
                                    <th class="border-bottom">User</th>
                                    <th class="border-bottom">Serial</th>
                                    <th class="border-bottom">Last Counter</th>
                                    <th class="border-bottom">Package Limit</th>
                                    <th class="border-bottom">Last Access</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if ($apps_result) {
                                    foreach ($apps_result['App_Id'] as $index => $app_id) {
                                        $app = $apps_result['Application_Name'][$index];
                                        echo "<tr>";
                                        // Available checkbox
                                        echo '<td class="text-center align-middle">
                                            <div class="form-check d-flex justify-content-center">
                                                <input class="form-check-input" name="Available_' . $app . '" type="checkbox" 
                                                       value="1"' . ($apps_result['availability'][$index] == 1 ? " checked" : "") . '>
                                            </div>
                                        </td>';
                                        // Blocked checkbox
                                        echo '<td class="text-center align-middle">
                                            <div class="form-check d-flex justify-content-center">
                                                <input class="form-check-input" name="Block_' . $app . '" type="checkbox" 
                                                       value="1"' . ($apps_result['Blocked'][$index] == 1 ? " checked" : "") . '>
                                            </div>
                                        </td>';
                                        echo '<td class="align-middle">' . $app . '</td>';
                                        echo '<td class="align-middle">' . $apps_result['Version'][$index] . '</td>';
                                        echo '<td class="align-middle">' . $apps_result['User'][$index] . '</td>';
                                        echo '<td class="align-middle">
                                            <span class="text-monospace">' . $apps_result['serial'][$index] . '</span>
                                        </td>';
                                        echo '<td class="align-middle text-end">' . number_format($apps_result['Last_Counter'][$index]) . '</td>';
                                        echo '<td class="align-middle">
                                            <div class="input-group input-group-sm">
                                                <input type="text" class="form-control package-limit" 
                                                       data-app="' . $app . '"
                                                       data-client="' . $ID . '"
                                                       value="' . $apps_result['Stop_At'][$index] . '" maxlength="6">
                                                <button class="btn btn-primary update-limit" type="button" 
                                                        data-app="' . $app . '"
                                                        data-client="' . $ID . '">
                                                    <i class="bi bi-check-lg"></i>
                                                </button>
                                            </div>
                                        </td>';
                                        echo '<td class="align-middle small text-muted">' . $apps_result['Time_stamp'][$index] . '</td>';
                                        echo "</tr>";
                                    }
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Balance & History (loaded on demand) -->
            <div class="card mt-4">
                <div class="card-header">
                    <ul class="nav nav-tabs card-header-tabs" id="balanceTabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="info-tab" data-bs-toggle="tab" href="#info" role="tab">Info</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="balance-tab" data-bs-toggle="tab" href="#balance" role="tab">Balance</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="invoices-tab" data-bs-toggle="tab" href="#invoices" role="tab">Invoices</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="payments-tab" data-bs-toggle="tab" href="#payments" role="tab">Payments</a>
                        </li>
                    </ul>
                </div>
                <div class="card-body tab-content">
                    <div class="tab-pane fade show active" id="info" role="tabpanel" aria-labelledby="info-tab">
                        <p class="text-muted mb-0">Open the Balance tab to load client credit and history.</p>
                    </div>
                    <div class="tab-pane fade" id="balance" role="tabpanel" aria-labelledby="balance-tab">
                        <div id="creditInfo"></div>
                    </div>
                    <div class="tab-pane fade" id="invoices" role="tabpanel" aria-labelledby="invoices-tab">
                        <div id="invoicesContainer" class="pt-2"></div>
                    </div>
                    <div class="tab-pane fade" id="payments" role="tabpanel" aria-labelledby="payments-tab">
                        <div id="paymentsContainer" class="pt-2"></div>
                    </div>
                </div>
            </div>
            
            <!-- MAC Addresses (moved to end, smaller width) -->
            <div class="row mt-4">
                <div class="col-lg-6">
                    <div class="card h-100">
                        <div class="card-header">
                            <h3 class="card-title">Machines Linked to License</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <?php get_list_mac(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
const SITE_URL = '<?php echo SITE_URL; ?>';

document.addEventListener('DOMContentLoaded', function() {
    // Lazy-load credit data when Balance tab is clicked first time
    let balanceLoaded = false;
    const balanceTab = document.getElementById('balance-tab');
    if (balanceTab) {
        balanceTab.addEventListener('shown.bs.tab', function () {
            if (!balanceLoaded) {
                loadCredit(<?php echo $ID; ?>);
                balanceLoaded = true;
            }
        });
    }

    // Lazy-load invoices when Invoices tab is clicked first time
    let invoicesLoaded = false;
    const invoicesTab = document.getElementById('invoices-tab');
    if (invoicesTab) {
        invoicesTab.addEventListener('shown.bs.tab', function () {
            if (!invoicesLoaded) {
                loadInvoices(<?php echo $ID; ?>);
                invoicesLoaded = true;
            }
        });
    }

    // Lazy-load payments when Payments tab is clicked first time
    let paymentsLoaded = false;
    const paymentsTab = document.getElementById('payments-tab');
    if (paymentsTab) {
        paymentsTab.addEventListener('shown.bs.tab', function () {
            if (!paymentsLoaded) {
                loadPayments(<?php echo $ID; ?>);
                paymentsLoaded = true;
            }
        });
    }

    // Package limit update handlers
    document.querySelectorAll('.update-limit').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            
            const inputElement = this.previousElementSibling;
            const appName = this.dataset.app;
            const clientId = this.dataset.client;
            const limitValue = inputElement.value;
            
            // Get both availability and blocked checkboxes for this app
            const availabilityCheckbox = document.querySelector(`input[name="Available_${appName}"]`);
            const blockedCheckbox = document.querySelector(`input[name="Block_${appName}"]`);
            const availability = availabilityCheckbox ? (availabilityCheckbox.checked ? 1 : 0) : null;
            const blocked = blockedCheckbox ? (blockedCheckbox.checked ? 1 : 0) : null;
            
            updateClientApplication(appName, clientId, limitValue, availability, blocked, this);
        });
    });

    // Availability checkbox handlers
    document.querySelectorAll('input[name^="Available_"]').forEach(checkbox => {
        checkbox.addEventListener('change', function(e) {
            if (!e.isTrusted) return;
            
            const appName = this.name.replace('Available_', '');
            const clientId = this.closest('tr').dataset.clientId || <?php echo $ID; ?>;
            const availability = this.checked ? 1 : 0;
            
            // Get the blocked checkbox state
            const blockedCheckbox = document.querySelector(`input[name="Block_${appName}"]`);
            const blocked = blockedCheckbox ? (blockedCheckbox.checked ? 1 : 0) : null;

            updateClientApplication(appName, clientId, null, availability, blocked);
        });
    });

    // Blocked checkbox handlers
    document.querySelectorAll('input[name^="Block_"]').forEach(checkbox => {
        checkbox.addEventListener('change', function(e) {
            if (!e.isTrusted) return;
            
            const appName = this.name.replace('Block_', '');
            const clientId = this.closest('tr').dataset.clientId || <?php echo $ID; ?>;
            const blocked = this.checked ? 1 : 0;
            
            // Get the availability checkbox state
            const availabilityCheckbox = document.querySelector(`input[name="Available_${appName}"]`);
            const availability = availabilityCheckbox ? (availabilityCheckbox.checked ? 1 : 0) : null;

            updateClientApplication(appName, clientId, null, availability, blocked);
        });
    });
});

function updateClientApplication(appName, clientId, limitValue, availability, blocked, button = null) {
    // Prevent empty updates
    if (limitValue === null && availability === null && blocked === null) {
        console.log('No values to update');
        return;
    }

    const formData = new FormData();
    formData.append('app', appName);
    formData.append('client_id', clientId);
    
    if (limitValue !== null) {
        formData.append('limit', limitValue);
    }
    if (availability !== null) {
        formData.append('availability', availability);
    }
    if (blocked !== null) {
        formData.append('blocked', blocked);
    }

    let originalButtonContent = '';
    if (button) {
        originalButtonContent = button.innerHTML;
        button.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>';
        button.disabled = true;
    }

    fetch(`${SITE_URL}/ajax/update_package_limit.php`, {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => {
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        return response.json();
    })
    .then(data => {
        if (data.success) {
            if (button) {
                button.innerHTML = '<i class="bi bi-check-lg"></i>';
                button.classList.remove('btn-primary');
                button.classList.add('btn-success');
                setTimeout(() => {
                    button.classList.remove('btn-success');
                    button.classList.add('btn-primary');
                }, 2000);
            }
        } else {
            throw new Error(data.message || 'Update failed');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        if (button) {
            button.innerHTML = '<i class="bi bi-x-lg"></i>';
            button.classList.remove('btn-primary');
            button.classList.add('btn-danger');
            setTimeout(() => {
                button.innerHTML = originalButtonContent;
                button.classList.remove('btn-danger');
                button.classList.add('btn-primary');
            }, 2000);
        }
    })
    .finally(() => {
        if (button) {
            button.disabled = false;
        }
    });
}

function loadCredit(clientId) {
    let creditInfo = document.getElementById('creditInfo');
    if (!creditInfo) {
        const balancePane = document.getElementById('balance');
        if (balancePane) {
            creditInfo = document.createElement('div');
            creditInfo.id = 'creditInfo';
            balancePane.appendChild(creditInfo);
        } else {
            return;
        }
    }
    creditInfo.innerHTML = '<div class="d-flex justify-content-center"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div></div>';
    
    fetch(SITE_URL + '/ajax/get_credit.php?client_id=' + clientId)
        .then(response => response.json())
        .then(data => {
            // Update the form with the fetched data
            updateFormWithCreditData(data);
            // Update the UI for old passport counts and enjaz historical data
            updateOldPassportCounts(data.old_passport_counts);
            updateEnjazHistoricalData(data.enjaz_historical_data);
        })
        .catch(error => {
            creditInfo.innerHTML = `Error loading credit information: ${error.message}`;
        });
}

function loadInvoices(clientId) {
    const container = document.getElementById('invoicesContainer');
    if (!container) return;
    container.innerHTML = '<div class="d-flex justify-content-center"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div></div>';

    fetch(`${SITE_URL}/api/invoices_get.php?client_id=${clientId}`)
        .then(r => r.json())
        .then(json => {
            if (!json.success) throw new Error(json.error || 'Failed to load invoices');
            const rows = (json.invoices || []).map(inv => `
                <tr>
                    <td>${inv.invoice_number || ''}</td>
                    <td>${inv.issue_date || ''}</td>
                    <td>${inv.due_date || '-'}</td>
                    <td><span class="badge bg-secondary">${(inv.status || '').replaceAll('_',' ')}</span></td>
                    <td>${inv.currency || ''}</td>
                    <td class="text-end">${Number(inv.total || inv.calculated_total || 0).toLocaleString(undefined,{minimumFractionDigits:2,maximumFractionDigits:2})}</td>
                    <td class="text-end">${inv.item_count || 0}</td>
                    <td>
                        <a class="btn btn-sm btn-info" href="?page=invoice_view&id=${inv.id}">View</a>
                        ${inv.status === 'draft' ? `<a class=\"btn btn-sm btn-warning ms-1\" href=\"?page=invoice_edit&id=${inv.id}\">Edit</a>` : ''}
                    </td>
                </tr>
            `).join('');

            container.innerHTML = `
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="mb-0">Invoices</h5>
                    <a class="btn btn-primary" href="?page=invoice_create&client_id=${clientId}">Create Invoice</a>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped mb-0">
                        <thead>
                            <tr>
                                <th>Invoice #</th>
                                <th>Issue Date</th>
                                <th>Due Date</th>
                                <th>Status</th>
                                <th>Currency</th>
                                <th class="text-end">Total</th>
                                <th class="text-end">Items</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            ${rows || '<tr><td colspan="8" class="text-center">No invoices found</td></tr>'}
                        </tbody>
                    </table>
                </div>
            `;
        })
        .catch(err => {
            container.innerHTML = `<div class="alert alert-danger mb-0">${err.message}</div>`;
        });
}

function loadPayments(clientId) {
    const container = document.getElementById('paymentsContainer');
    if (!container) return;
    container.innerHTML = '<div class="d-flex justify-content-center"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div></div>';

    fetch(`${SITE_URL}/api/payments_get.php?client_id=${clientId}`)
        .then(r => r.json())
        .then(json => {
            if (!json.success) throw new Error(json.error || 'Failed to load payments');
            const rows = (json.payments || []).map(p => `
                <tr>
                    <td>${p.payment_date || ''}</td>
                    <td class="text-end">${Number(p.amount || 0).toLocaleString(undefined,{minimumFractionDigits:2,maximumFractionDigits:2})}</td>
                    <td>${p.currency || ''}</td>
                    <td><span class="badge bg-info">${(p.method || '').charAt(0).toUpperCase() + (p.method || '').slice(1)}</span></td>
                    <td>${p.reference ? String(p.reference) : '-'}</td>
                    <td class="text-end">${Number(p.allocated_amount || 0).toLocaleString(undefined,{minimumFractionDigits:2,maximumFractionDigits:2})} / ${Number(p.amount || 0).toLocaleString(undefined,{minimumFractionDigits:2,maximumFractionDigits:2})}</td>
                    <td>
                        <a class="btn btn-sm btn-info" href="?page=payment_view&id=${p.id}">View</a>
                        ${Number(p.allocated_amount || 0) < Number(p.amount || 0) ? `<a class=\"btn btn-sm btn-warning ms-1\" href=\"?page=payment_allocate&id=${p.id}\">Allocate</a>` : ''}
                    </td>
                </tr>
            `).join('');

            container.innerHTML = `
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="mb-0">Payments</h5>
                    <a class="btn btn-primary" href="?page=payment_create&client_id=${clientId}">Record Payment</a>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped mb-0">
                        <thead>
                            <tr>
                                <th>Payment Date</th>
                                <th class="text-end">Amount</th>
                                <th>Currency</th>
                                <th>Method</th>
                                <th>Reference</th>
                                <th class="text-end">Allocated</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            ${rows || '<tr><td colspan="7" class="text-center">No payments found</td></tr>'}
                        </tbody>
                    </table>
                </div>
            `;
        })
        .catch(err => {
            container.innerHTML = `<div class="alert alert-danger mb-0">${err.message}</div>`;
        });
}

function updateFormWithCreditData(data) {
    const creditInfo = document.getElementById('creditInfo');
    if (!creditInfo) return;
    creditInfo.innerHTML = '';

    if (!data) {
        creditInfo.innerHTML = '<div class="alert alert-warning mb-0">No credit information available.</div>';
        return;
    }

    const kpiCard = (title, value, icon, color) => `
        <div class="col-md-4 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="flex-shrink-0 me-3">
                        <span class="badge rounded-circle bg-${color} p-3"><i class="bi ${icon}"></i></span>
                    </div>
                    <div class="flex-grow-1">
                        <div class="text-muted small">${title}</div>
                        <div class="fs-5 fw-semibold">${value.toLocaleString()}</div>
                    </div>
                </div>
            </div>
        </div>`;

    const listItems = (obj) => Object.entries(obj)
        .map(([k, v]) => `<tr><td class="text-muted">${k}</td><td class="text-end fw-semibold">${Number(v).toLocaleString()}</td></tr>`) 
        .join('');

    const passportsList = (obj) => Object.entries(obj)
        .map(([k, total]) => `<tr><td class="text-muted">${k}</td><td class="text-end fw-semibold">${Number(total).toLocaleString()}</td></tr>`)
        .join('');

    creditInfo.innerHTML = `
        <div class="row">
            ${kpiCard('Printed Visa Counter', Number(data.printed_visa_counter || 0), 'bi-printer', 'primary')}
            ${kpiCard("Current Year Total", Object.values(data.current_year || {}).reduce((a,b)=>a+Number(b||0),0), 'bi-calendar-event', 'success')}
            ${kpiCard("Yesterday's Total", Object.values(data.yesterday_count || {}).reduce((a,b)=>a+Number(b||0),0), 'bi-clock-history', 'warning')}
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <div class="card shadow-sm h-100">
                    <div class="card-header bg-light fw-semibold">Current Year Visa Counts</div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <tbody>
                                    ${listItems(data.current_year || {})}
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="card shadow-sm h-100">
                    <div class="card-header bg-light fw-semibold">Yesterday's Visa Counts</div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <tbody>
                                    ${listItems(data.yesterday_count || {})}
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12 mb-3">
                <div class="card shadow-sm">
                    <div class="card-header bg-light fw-semibold">Passport Counts</div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead class="table-light">
                                    <tr><th>Visa Type</th><th class="text-end">Total Passports</th></tr>
                                </thead>
                                <tbody>
                                    ${passportsList(data.passport_counts || {})}
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <div class="card shadow-sm" id="old-passport-counts" style="display:none;">
                    <div class="card-header bg-light fw-semibold">Old Passport Counts</div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead class="table-light">
                                    <tr><th>Year</th><th class="text-end">Total</th></tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="card shadow-sm" id="enjaz-historical-data" style="display:none;">
                    <div class="card-header bg-light fw-semibold">Enjaz Historical Data</div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead class="table-light">
                                    <tr><th>Year</th><th class="text-end">Total</th></tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    `;
}

function updateOldPassportCounts(oldPassportCounts) {
    const container = document.getElementById('old-passport-counts');
    if (!container) return;
    const oldPassportTableBody = container.querySelector('tbody');
    if (!oldPassportTableBody) return;
    oldPassportTableBody.innerHTML = '';
    let allZero = true;

    const yearsDesc = Object.keys(oldPassportCounts)
        .sort((a, b) => Number(b) - Number(a));

    yearsDesc.forEach(year => {
        const total = oldPassportCounts[year].total;
        if (total > 0) {
            allZero = false;
        }
        oldPassportTableBody.innerHTML += `<tr><td>${year}</td><td class="text-end">${total}</td></tr>`;
    });

    // Hide the section if all counts are zero
    container.style.display = allZero ? 'none' : 'block';
}

function updateEnjazHistoricalData(enjazHistoricalData) {
    const container = document.getElementById('enjaz-historical-data');
    if (!container) return;
    const enjazTableBody = container.querySelector('tbody');
    if (!enjazTableBody) return;
    enjazTableBody.innerHTML = '';
    let allZero = true;

    for (const year in enjazHistoricalData) {
        const total = enjazHistoricalData[year].total;
        if (total > 0) {
            allZero = false;
        }
        enjazTableBody.innerHTML += `<tr><td>${year}</td><td>${total}</td></tr>`;
    }

    // Hide the section if all counts are zero
    container.style.display = allZero ? 'none' : 'block';
}
</script>
</body>
</html>
