<?php
require_once("../includes/config.php");
$machineId = isset($_GET['code']) ? $_GET['code'] : die("Machine code is not provided.");

try {
    // Look up the value for redirect URL
    $lookupQuery = "SELECT safa_client_id FROM crm_ea_machines WHERE code = :code";
    $lookupStmt = $db1->prepare($lookupQuery);
    $lookupStmt->bindParam(':code', $machineId, PDO::PARAM_INT);
    $lookupStmt->execute();
    $result = $lookupStmt->fetch(PDO::FETCH_ASSOC);
    $clientId = $result['safa_client_id'];

    // Prepare and execute the update query
    $updateQuery = "UPDATE crm_ea_machines SET safa_client_id = NULL WHERE code = :code";
    $updateStmt = $db1->prepare($updateQuery);
    $updateStmt->bindParam(':code', $machineId, PDO::PARAM_INT);
    $updateStmt->execute();

    // Check if any rows were affected by the update
    $rowCount = $updateStmt->rowCount();
    if ($rowCount > 0) {
        // Redirect to the specified URL with the dynamic value
        $redirectUrl = SITE_URL."/?page=edit_client&id=" . $clientId;
        header("Location: " . $redirectUrl);
        exit;
    } else {
        echo "No matching records found.";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
