<?php include_once("includes/config.php"); ?>
<style>
    .container {
        max-width: 1200px;
        padding: 2rem;
    }
    .formLayout {
        background: white;
        padding: 1.5rem;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        margin-bottom: 2rem;
    }
    .form-control {
        border-radius: 25px;
        padding: 0.75rem 1.5rem;
        border: 1px solid #e0e0e0;
        transition: all 0.3s ease;
    }
    .form-control:focus {
        box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25);
        border-color: #dc3545;
    }
    .btn {
        padding: 0.75rem 1.5rem;
        border-radius: 25px;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    .btn-primary {
        background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        border: none;
        box-shadow: 0 4px 15px rgba(220, 53, 69, 0.3);
    }
    .btn-primary:hover {
        background: linear-gradient(135deg, #c82333 0%, #bd2130 100%);
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(220, 53, 69, 0.4);
    }
    .table-responsive {
        background: white;
        padding: 1.5rem;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }
    .failed {
        background: #f8d7da;
        color: #721c24;
        padding: 1rem 1.5rem;
        border-radius: 15px;
        border: 1px solid #f5c6cb;
        margin: 1rem 0;
    }
</style>

<div class="container">
    <div class="formLayout">
        <?php $Page = "search_clients"; ?>

        <h3>Search Clients</h3>

        <form action="" method="get" class="d-flex flex-column gap-2">
            <input type="text" name="search" placeholder="Search by company name or email" class="form-control">
            <button type="submit" class="btn btn-primary w-100">Search</button>
        </form>

        <?php if(isset($_GET['search'])): ?>
            <?php Search_Clients($_GET['search']); ?>
        <?php endif; ?>
    </div>
</div>
    
<br />
<br />
<br />

<?php
function Search_Clients($search_term) {
    global $db1;
    
    $table_suffix = 1446; // Replace this number as needed
    $passports = "passports_" . $table_suffix . "_2024";
    
    $sql = "SELECT *,
        (SELECT license_code FROM license WHERE client_id = tbl_clients.Id LIMIT 1) AS LicenseCode,
        (SELECT stop_at FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) AS credit,
        (SELECT time_stamp FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) AS last_access
        FROM tbl_clients 
        WHERE CompanyName LIKE :companyname
        ORDER BY (SELECT time_stamp FROM tbl_clients_applications WHERE app_id = 4 AND client_id = tbl_clients.id LIMIT 1) DESC";

    $stmt = $db1->prepare($sql);
    $stmt->bindValue(':companyname', '%' . $search_term . '%');
    $stmt->execute();
    
    if ($stmt === false) {
        echo "Query error: " . $stmt->errorInfo()[2];
        return;
    }
    
    $count = $stmt->rowCount();
    
    if ($count == 0) {
        echo "
        <div class='failed'>
            <img src='../images/error_icon.png' width='16' height='16' alt='Successfully' />
            Sorry! No Result Found
        </div>";
        return;
    }
    
    echo "<div class='container mt-3'>";
    echo "<div class='table-responsive'>";
    echo "Result <strong>($count)</strong>";
    echo "<table class='table table-striped table-bordered table-hover'>";
    echo "<thead class='thead-dark'>";
    echo "<tr>";
    echo "<th scope='col'>Company Name</th>";
    echo "<th scope='col'>License Code</th>";
    echo "<th scope='col'>Credit</th>";
    echo "<th scope='col'>Last Access</th>";
    echo "<th scope='col'>Edit</th>";                
    echo "</tr>";
    echo "</thead>";
    echo "<tbody>";
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "<tr class='text-center'>";
        echo "<td>" . htmlspecialchars($row['CompanyName'] ?? '') . "</td>";
        echo "<td>" . htmlspecialchars($row['LicenseCode'] ?? '') . "</td>";
        echo "<td>" . htmlspecialchars($row['credit'] ?? '') . "</td>";
        echo "<td>" . htmlspecialchars($row['last_access'] ?? '') . "</td>";
        echo "<td>
        <a href='?page=edit_client&id={$row['Id']}' class='btn btn-outline-secondary'>
            <i class='bi bi-pencil'></i>
        </a>
        </td>"; 
        echo "</tr>";
    }
    
    echo "</tbody>";
    echo "</table>";
    echo "</div>";
    echo "</div>";
}
?>

    <!-- ========== DELETE CLIENT  ======================== -->
    <script src="../includes/js/Delete_Client.js" type="text/javascript"></script>
    <!-- ================================================== -->